@extends('layouts.master')

@section('title')
    اضافة اختبار جديد
@endsection

@section('first-css')
@endsection

@section('content-body')
    <!--**********************************
                Content body start
            ***********************************-->
            @include('massages')

    <!-- row -->
    <div class="container-fluid">
        <div class="row invoice-card-row">
            <div class="row invoice-card-row">

                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title ">اضافة اختبار جديد</h4>
                        </div>
                        <div class="card-body pb-3 tran ">
                            <div class="form-validation">
                                <form class="validation needs-validation form-disable" novalidate method="POST" action="{{route('exam_store')}}">
                                   @csrf
                                    <div class="row border-bottom pb-3 mb-2">
                                        <div class="col-12 col-md-4">
                                            <label class="form-label fw-bold" for="name">نوع الاختبار</label>
                                            <select class="form-control form-white inputRead" data-placeholder="Choose a color..." name="typeExams" required="">
                                                <option disabled="disabled" selected="" value="">الرجاء اختيار احد
                                                    الانواع</option>
                                                <option value="0">اختبار قبلي</option>
                                                <option value="1">اختبار بعدي</option>
                                                <option value="2">اختبار اجتياز</option>
                                            </select>
                                            @error('typeExams')
                                            <div class="text-danger px-2 showModalAdd ">
                                              {{ $message }}
                                            </div>
                                          @enderror
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <label class="form-label fw-bold" for="name">الصف الدراسي</label>
                                            <select class="form-control form-white inputRead" data-placeholder="Choose a color..." name="roomClass" required="">
                                                <option disabled="disabled" selected="" value="">الرجاء اختيار احد
                                                    الدورات التدريبية</option>
                                                    @isset($rooms)
                                                    @foreach ($rooms    as $room)
                                                        <option value="{{$room->id}}"> {{$room->name}} برنامج {{$room->course->title}} </option>
                                                    @endforeach
                                                @endisset
                                            </select>
                                            @error('roomClass')
                                            <div class="text-danger px-2 showModalAdd ">
                                              {{ $message }}
                                            </div>
                                          @enderror
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <label class="form-label fw-bold" for="expireTime"> وقت وتاريخ إنتهاء الإحتبار</label>
                                            <input type="datetime-local" id="expireTime " value="" name="expireTime" class="form-control text quation-tilte" placeholder="الرجاء تحديد الوقت" required="" >
                                            @error('expireTime')
                                            <div class="text-danger px-2 showModalAdd ">
                                              {{ $message }}
                                            </div>
                                          @enderror
                                        </div>
                                   </div>
                                   <div class="card-header">
                                        <h5 class="card-title ">اسئلة الاختبار</h5>
                                    </div>
                                    <div class=" all-quations   py-3 mb-2" id="allQuationts">

                                    </div>
                                    <div class="col-xl-12 mt-2" style="direction: rtl;">
                                        <span id="add" class="btn btn-success">اضافة سؤال جديد +</span>
                                    </div>
                                    <div class="col-xl-12" style="direction: ltr;">
                                        <button type="submit" class="btn btn-primary me-sm-3 me-1 showModal" data-title="هل تريد حفظ هذا الاختبار؟">حفظ </button>
                                    </div>
                            </form>
                        </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <!--**********************************
                Content body end
    ***********************************-->


@endsection

@section('script')
<script src="{{ asset('/js/exam/add-new-qution.js') }}"></script>
    <script src="{{ asset('/vendor/datatables/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/js/plugins-init/datatables.init.js') }}"></script>
@endsection
